#ifndef ODECONTROLLER_H_
#define ODECONTROLLER_H_
#include <ode/ode.h>
#include <drawstuff/drawstuff.h>
#include "IPhysicsController.h"
#include <map.h>
#include <stdio.h>
#include <stdlib.h>

using namespace DataTypes;
using namespace std;
namespace PhysicsEngine
{

void nearCollisionCallback(void* _this, dGeomID id1, dGeomID id2);

class ODEController : public PhysicsEngine::IPhysicsController
{
public:
	ODEController();
	virtual ~ODEController();
	void InitWorld();
	void ResetWorld();
	void StepWorld(float timestep, int steps, bool fastmode);
	void FreeResources();
	IPhysicalBody *CreatePhysicalBody(int entityid, DataBody *data);
	IPhysicalJoint *CreatePhysicalJoint(DataJoint *data, IPhysicalBody *body1, IPhysicalBody *body2);
	string GetDrawData();
	map<int, IPhysicalBody *> GetBodies();
	void SetWorldHardness(float hardness);
	void SetWorldBounciness(float bounciness);
	void SetWorldGravity(float gravx, float gravy, float gravz);
	friend void nearCollisionCallback(void* _this, dGeomID id1, dGeomID id2);
private:
	DataInteraction GetDefaultInteraction();
	dWorldID odeworld;
	dSpaceID mainspace;
	dJointGroupID contactgroup;
	map<int, dSpaceID> spaces;
	map<int, IPhysicalBody*> bodies; //key is dgeomid
};

}

#endif /*ODECONTROLLER_H_*/
